/*
 * Decompiled with CFR 0.152.
 */
package core.modes;

import core.GameWindow;
import core.states.GameState;
import java.util.Random;
import util.ResourceManager;

public abstract class GameMode {
    protected GameState gamestate;
    protected GameWindow window;
    protected int width;
    protected int height;
    protected int level;
    protected Random random = new Random();

    public GameMode(GameState gamestate) {
        this.gamestate = gamestate;
        this.window = ResourceManager.get().getGameWindow();
        this.width = (int)ResourceManager.get().getDimension().getWidth();
        this.height = (int)ResourceManager.get().getDimension().getHeight();
    }

    public abstract void startScreen();

    public void startLevel() {
        this.level = this.gamestate.getLevel();
    }

    public abstract void render(long var1);

    public void drawMessage() {
        this.window.drawText(GameWindow.FONT_MENU, GameState.message.x, GameState.message.y, GameState.message.text, 2);
    }

    public void playerDead() {
        if (this.gamestate.isWaitingForKeyPress()) {
            return;
        }
        this.gamestate.increaseDeathCount();
        GameState.message.text = "You lost!\nPress Space to retry this level";
        GameState.message.x = this.width / 2;
        GameState.message.y = 245;
        this.gamestate.setWaitingForKeyPress(true);
        ResourceManager.get().playSound("level_lose");
    }

    public void afterGameLost() {
        this.gamestate.startLevel();
    }
}

